var PlaceholderReplacer = (function() {
    var root = this;

    root.replace = function(placeholder) {
        var templateSelector = placeholder.getAttribute('data-placeholder');
        var template = document.querySelector(templateSelector);
        if (!template) {
            console.error('Template ' + templateSelector + ' not found');
            return;
        }

        var clone = template.content.cloneNode(true).firstElementChild;
        placeholder.parentElement.replaceChild(clone, placeholder);
    }

    root.replacePlaceholders = function(element) {
        var placeholders = element.querySelectorAll('[data-placeholder]');
        for (var i = 0; i < placeholders.length; i++) {
            root.replace(placeholders[i]);
        }
    }

    return root;
});