var MessageBox = function() {
    const root = this;
    root.element = null;
    
    root.createElement = function() {
        var container = document.createElement("div");
        container.className = "message-box fixed-top w-100 h-100 dark-backdrop d-flex justify-content-center align-items-center fadeIn easeInDefaultInterpolator time0s25ms";
        container.hidden = true;

        var content = document.createElement("div");
        content.className = "p-3 fadeAndUpIn easeInDefaultInterpolator time0s5ms";
        container.appendChild(content);

        var message = document.createElement("div");
        message.className = "bg-dark text-white p-3 content";

        var text = document.createElement("p");
        text.className = "message mb-0";
        message.appendChild(text);
        content.appendChild(message);

        return container;
    }

    root.init = function() {
        if(!root.element) {
            root.element = root.createElement();
        }

        return root;
    }

    root.setText = function(text) {
        root.element.querySelector(".message").innerText = text;
        return this;
    }

    root.show = function(text) {
        if(text) {
            root.setText(text);
        }

        document.body.appendChild(root.element);
        root.element.hidden = false;
        return this;
    }

    root.fadeOut = function() {
        root.element.style.opacity = 1;
        gsap.to(root.element, {
            duration: 0.25,
            opacity: 0,
            onComplete: function() {
                root.element.hidden = true;
                root.element.style.opacity = 1;
                root.element.remove();
            }
        });

        return this;
    }

    root.hide = function(timeout) {
        if(!timeout) {
            root.fadeOut();
            return this;
        }

        setTimeout(function(root) {
            root.fadeOut();
        }, timeout, root);
        return this;
    }

    root.init();
    return root;
}