var LoadingScreen = function(){
    var root = this;
    root.element = null;

    root.isVisible = function() {
        return !root.element.hidden;
    }
    
    root.createElement = function createElement() {
        var container = document.createElement("div");
        container.className = "fixed-top w-100 h-100 bar-bg z-3 d-flex justify-content-center align-items-center loading-screen flex-column";
        container.hidden = true;

        var iconContainer = document.createElement("h1");
        iconContainer.className = "text-primary easeInDefaultInterpolator time0s25ms zoomIn";
        container.appendChild(iconContainer);

        var spinner = document.createElement("div");
        spinner.className = "spin-2s";
        iconContainer.appendChild(spinner);

        var icon = document.createElement("i");
        icon.className = "fa-solid fa-circle-notch fa-2x";
        spinner.appendChild(icon);

        var text = document.createElement("p");
        text.className = "lead loading-text easeInDefaultInterpolator time0s5ms fadeAndUpIn text-center pt-2";
        container.appendChild(text);

        return container;
    }
    
    root.init = function() {
        if(!root.element) {
            root.element = root.createElement();
        }

        return root;
    }

    root.setText = function(text) {
        root.element.querySelector(".loading-text").innerText = text;
        return this;
    }

    root.show = function(text) {
        if(text) {
            root.setText(text);
        }

        document.body.appendChild(root.element);
        root.element.hidden = false;
        return this;
    }

    root.fadeOut = function() {
        root.element.style.opacity = 1;
        gsap.to(root.element, {
            duration: 0.25,
            opacity: 0,
            onComplete: function() {
                root.element.hidden = true;
                root.element.style.opacity = 1;
                root.element.remove();
            }
        });

        return this;
    }

    root.hide = function(timeout) {
        if(!timeout) {
            root.fadeOut();
            return this;
        }

        setTimeout(function(root) {
            root.fadeOut();
        }, timeout, root);
        return this;
    }

    root.init();

    return root;
}