var EntityService = function(entityName) {
    var root = this;
    root.entityName = entityName;
    root.entities = [];

    root.generateId = function() {
        return Math.floor(Math.random() * 1000) +"r"+ Date.now();
    }

    root.save = function() {
        localStorage.setItem(root.entityName, JSON.stringify(root.entities));
    }

    root.load = function() {
        root.entities = JSON.parse(localStorage.getItem(root.entityName)) || [];
    }

    root.add = function(entity) {
        if(!entity.id) {
            entity.id = root.generateId();
        } else {
            root.removeById(entity.id);
        }

        root.entities.push(entity);
        root.save();
    }

    root.remove = function(entity) {
        root.entities = root.entities.filter(function(s) {
            return s.url != entity.url;
        });
        root.save();
    }

    root.getById = function(id) {
        return root.entities.find(function(s) {
            return s.id == id;
        });
    }

    root.removeById = function(id) {
        root.entities = root.entities.filter(function(s) {
            return s.id != id;
        });
        root.save();
    }

    root.getAll = function() {
        return root.entities;
    }

    root.where = function(predicate) {
        return root.entities.filter(predicate);
    }

    root.load();
    return root;
}