var SettingsManager = function() {
    var root = this;
    root.settings = {};

    root.get = function(key) {
        return root.settings[key];
    }

    root.set = function(key, value) {
        root.settings[key] = value;
        root.save();
    }

    root.save = function() {
        localStorage.setItem("settings", JSON.stringify(root.settings));
    }

    root.load = function() {
        var settings = localStorage.getItem("settings");
        if(settings) {
            root.settings = JSON.parse(settings);
        }
    }

    root.setAll = function(settings) {
        root.settings = settings;
        root.save();
    }

    root.getAll = function() {
        return root.settings;
    }

    root.load();
    return root;
}