var PageLoader = function() {
    var root = this;
    root.listeners = {};
    root.pages = [];
    root.injections = [];
    root.middlewares = [];
    root.loadingProgress = 0;
    root.loadedPageCount = 0;
    root.currentRequestProgress = 0;
    root.currentPage = null;
    root.avoidCaching = false;

    root.getQueryParams = function() {
        var url = location.href;
        var obj = {};
        var query = url.split("?")[1];
        if(!query) {
            return obj;
        }

        var params = query.split("&");
        if(params.length == 0) {
            return obj;
        }

        for (var i = 0; i < params.length; i++) {
            var pair = params[i].split("=");
            obj[decodeURI(pair[0])] = decodeURI(pair[1]);
        }

        return obj;
    }

    root.addEventListener = function (eventName, callback) {
        if(!root.listeners[eventName]) {
            root.listeners[eventName] = [];
        }
        root.listeners[eventName].push(callback);
    }

    root.dispatchEvent = function (eventName, data) {
        if(root.listeners[eventName]) {
            for (var i = 0; i < root.listeners[eventName].length; i++) {
                root.listeners[eventName][i](data);
            }
        }
    }

    root.getDefaultPage = function () {
        for (var i = 0; i < root.pages.length; i++) {
            if(root.pages[i].default) {
                return root.pages[i].name;
            }
        }
    }

    root.getCurrentPageName = function () {
        return window.location.hash.substring(1).split("?")[0];
    }

    root.getPage = function (pageName) {
        for (var i = 0; i < root.pages.length; i++) {
            if(root.pages[i].name == pageName) {
                return root.pages[i];
            }
        }
    }

    root.getUnauthorizedPage = function () {  
        for (var i = 0; i < root.pages.length; i++) {
            if(root.pages[i].type == "unauthorized") {
                return root.pages[i];
            }
        }
    }

    root.getPageElement = function (pageName) {
        for (var i = 0; i < root.pages.length; i++) {
            if(root.pages[i].name == pageName) {
                return root.pages[i].element;
            }
        }
    }

    root.getCurrentPageElement = function () {
        return root.getPageElement(root.getCurrentPageName());
    }

    root.goToPage = function (pageName) {        
        pageName = pageName.split("?")[0]

        if(pageName.charAt(0) == "/") {
            pageName = pageName.substring(1);
        }

        if(root.currentPage && root.currentPage.name == pageName) {
            return;
        }

        if (pageName != root.getCurrentPageName()) {
            window.location.hash = "#" + pageName
            return;
        }

        var page = root.getPage(pageName);
        if (page) {
            if(page.condition) {
                if(!page.condition()) {
                    var unauthorizedPage = root.getUnauthorizedPage();
                    if(unauthorizedPage) {
                        root.goToPage(unauthorizedPage.name);
                    } else {
                        window.location.hash = "#" + root.getDefaultPage()
                    }
                    return;
                }
            }

            root.dispatchEvent('pagebeforechange', page);
            page.element.dispatchEvent(new Event('pagebeforechange'))
            if(root.currentPage) {
                root.currentPage.element.remove();
                root.dispatchEvent('pagehidden', root.currentPage);
                root.currentPage.element.dispatchEvent(new Event('pagehidden'));
            }

            root.currentPage = page;
            document.body.appendChild(page.element)
            root.dispatchEvent('pageshown', page);
            page.element.dispatchEvent(new Event('pageshown'));
        } else {
            console.error('Page ' + pageName + ' not found')
            window.location.hash = "#" + root.getDefaultPage()
        }
    }

    root.addMiddleware = function(middleware) { 
        root.middlewares.push(middleware);
    };

    root.getContent = function(url) {
        return new Promise(function(resolve, reject) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", url, true);
            xhr.onreadystatechange = function() {
                if(xhr.readyState == 4) {
                    if(xhr.status == 200) {
                        resolve(xhr.responseText);
                    } else {
                        reject(xhr.status);
                        window.onerror(xhr.responseText + " ," + xhr.status);
                    }
                }
            }

            xhr.send();
        });
    }

    root.addPage = function(page) {
        root.pages.push(page);
    }

    root.getRand = function() {
        return Math.floor(Math.random() * 99999999);
    }

    root.getMiddlewaresOfType = function(type) {
        var coincidences = [];
        for (var i = 0; i < root.middlewares.length; i++) {
            if(root.middlewares[i].type == type) {
                coincidences.push(root.middlewares[i]);
            }
        }
        return coincidences;
    }

    root.init = function() {    
        window.addEventListener('hashchange', function () {
            root.goToPage(root.getCurrentPageName())
        })
    
        var currentPage = root.getCurrentPageName()
        if (currentPage == "") {
            root.goToPage(root.getDefaultPage())
        } else {
            root.goToPage(currentPage)
        }
    
    }

    root.load = function() {
        var promises = [];
        root.loadingProgress = 0;
        root.loadedPageCount = 0;
        if(root.onprogress) {
            root.onprogress(root);
        }
        for (var i = 0; i < root.pages.length; i++) {
            var page = root.pages[i];
            promises.push((function(page) {
                var pageElement = document.createElement("div");
                pageElement.classList.add("page");
                if(page.default) {
                    pageElement.classList.add("default");
                    pageElement.setAttribute("data-page-default", "true");
                }

                pageElement.setAttribute("data-page", page.name);
                
                var contentPromise = root.getContent(page.path + "/index.html"+ (root.avoidCaching ? "?___Z=" + root.getRand() : ""));
                var scriptPromise = root.getContent(page.path + "/index.js" + (root.avoidCaching ? "?___Z=" + root.getRand() : ""));
                var innerPromises = [contentPromise, scriptPromise];

                var promise = Promise.all(innerPromises).then(function(results) {
                    pageElement.innerHTML = results[0];

                    var domMiddlewares = root.getMiddlewaresOfType("dom");
                    for (var i = 0; i < domMiddlewares.length; i++) {
                        domMiddlewares[i].callback(pageElement);
                    }

                    (function(script, pageElement, page) {
                        var scriptContentMiddlewares = root.getMiddlewaresOfType("script");
                        for (var i = 0; i < scriptContentMiddlewares.length; i++) {
                            script = scriptContentMiddlewares[i].callback(script);
                        }
                        
                        try {
                            //var builderFunction = new Function("injector", innerFunctionContent);
                            page.element = pageElement;   
                            eval(script);
                                
                            if(root.injector) {
                                root.injector.addSingleton("container", pageElement);
                                page.controller = root.injector.inject(IndexController);
                                root.injector.removeDependency("container");
                            } else {
                                page.controller = new IndexController();
                            }

                            root.loadedPageCount++; 
                            root.loadingProgress = root.loadedPageCount / (root.pages.length);
                            if(root.onprogress) {
                                root.onprogress(root);
                            }
                        } catch(e) {
                            console.error(e, page);
                        }
                    })(results[1], pageElement, page);
                });

                return promise;
            })(page));
        }

        return new Promise(function(resolve, reject) {
            Promise.all(promises).then(function() {
                root.init();
                resolve();
            });
        });
    }

    return root;
}