var DependencyInjector = function() {
    var root = this;
    root.dependencies = [];

    root.getDependencyByName = function(name) {
        for (var i = 0; i < this.dependencies.length; i++) {
            if(this.dependencies[i].name == name) {
                return this.dependencies[i];
            }
        }
    }

    root.get = function(name) { 
        var existingDependency = this.getDependencyByName(name);
        if(existingDependency) {
            var instance = existingDependency.instance;
            if(typeof instance === "function") {
                instance = this.inject(instance);
            }
            
            return instance;
        } else { 
            return null;
        }
    }

    root.getParameters = function(func) {
        if(!func) 
            return [];

        var functionStringDefinition = func.toString().replace(/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/mg);
        var isClass = functionStringDefinition.includes("constructor");
        var indexOfArguments = 0;
        if(isClass) {
            indexOfArguments = functionStringDefinition.indexOf('(', functionStringDefinition.indexOf("constructor")) + 1
        } else {
            indexOfArguments = functionStringDefinition.indexOf('(') + 1
        }
        var argumentArray = functionStringDefinition.slice(indexOfArguments, functionStringDefinition.indexOf(')', indexOfArguments)).match(/([^\s,]+)/g);
        if (argumentArray === null)
            argumentArray = [];
        return argumentArray;
    };

    root.addTransient = function(name, instance) {
        this.addDependency({
            "name": name,
            "instance": instance
        })
    }

    root.addSingleton = function(name, instance) {
        if(typeof instance == "function") {
            instance = this.inject(instance);
        }

        this.addDependency({
            "name": name,
            "instance": instance
        })
    }

    root.addDependency = function(dependency) {
        var existingDependency = this.get(dependency.name);
        if(existingDependency) {
            existingDependency.instance = dependency.instance
            return existingDependency.instance;
        } else {
            this.dependencies.push(dependency)
            return dependency.instance;
        }
    }
    
    root.removeDependency = function(name) {
        var existingDependency = this.getDependencyByName(name);
        if(existingDependency) {
            this.dependencies.splice(this.dependencies.indexOf(existingDependency), 1);
        }
    }

    root.resolveDependencies = function(dependencies) {
        var resolvedDependencies = [];
        for (var i = 0; i < dependencies.length; i++) {
            var dependency = dependencies[i];
            var resolvedDependency = this.get(dependency);
            resolvedDependencies.push(resolvedDependency || null);
        }
        return resolvedDependencies;
    }

    root.inject = function(module) {
        if(!module)
            return null;

        var moduleParameters = this.getParameters(module);
        var dependencies = this.resolveDependencies(moduleParameters);
        return module.prototype ? new (module.bind.apply(module, [null].concat(dependencies)))() : module.apply(null, dependencies);
    }

    return root;
}

