
const Main = function () {
    var root = this;
    root.loadingScreen = new LoadingScreen();
    root.messageBox = new MessageBox(document.querySelector(".message-box"));
    root.placeholderReplacer = new PlaceholderReplacer();
    root.dependencyInjector = new DependencyInjector();
    root.subscriptionService = new EntityService("subscriptions");
    root.settingsManager = new SettingsManager();
    root.pageLoader = new PageLoader();
    root.mainCurrencyId = root.settingsManager.get("mainCurrencyId") || "USD";
    root.decimalCount = 2;
    root.currencies = [
        {
            "id": "USD",
            "name": "US Dollar",
            "symbol": "$",
            "format": "en-US"
        },
        {
            "id": "EUR",
            "name": "Euro",
            "symbol": "€",
            "format": "de-DE"
        },
        {
            "id": "GBP",
            "name": "British Pound",
            "symbol": "£",
            "format": "en-GB"
        },
        {
            "id": "JPY",
            "name": "Japanese Yen",
            "symbol": "¥",
            "format": "ja-JP"
        },
        {
            "id": "AUD",
            "name": "Australian Dollar",
            "symbol": "$",
            "format": "en-AU"
        },
        {
            "id": "CAD",
            "name": "Canadian Dollar",
            "symbol": "$",
            "format": "en-CA"
        },
        {
            "id": "CHF",
            "name": "Swiss Franc",
            "symbol": "CHF",
            "format": "fr-CH"
        },
        {
            "id": "CNY",
            "name": "Chinese Yuan",
            "symbol": "¥",
            "format": "zh-CN"
        },
        {
            "id": "SEK",
            "name": "Swedish Krona",
            "symbol": "kr",
            "format": "sv-SE"
        },
        {
            "id": "NZD",
            "name": "New Zealand Dollar",
            "symbol": "$",
            "format": "en-NZ"
        },
        {
            "id": "KRW",
            "name": "South Korean Won",
            "symbol": "₩",
            "format": "ko-KR"
        },
        {
            "id": "SGD",
            "name": "Singapore Dollar",
            "symbol": "$",
            "format": "en-SG"
        },
        {
            "id": "NOK",
            "name": "Norwegian Krone",
            "symbol": "kr",
            "format": "nb-NO"
        },
        {
            "id": "MXN",
            "name": "Mexican Peso",
            "symbol": "$",
            "format": "es-MX"
        },
        {
            "id": "INR",
            "name": "Indian Rupee",
            "symbol": "₹",
            "format": "hi-IN"
        },
        {
            "id": "DOP",
            "name": "Dominican Peso",
            "symbol": "RD$",
            "format": "es-DO"
        }
    ]

    root.setupPageLoader = function () {
        root.pageLoader.injector = root.dependencyInjector;
        root.pageLoader.addMiddleware({
            type: "dom",
            callback: function (element) {
                root.placeholderReplacer.replacePlaceholders(element);
            }
        })

        root.pageLoader.onprogress = function (loader) {
            root.loadingScreen.setText(Math.round(loader.loadingProgress * 100) + "%");
        }

        root.addPages();
    }

    root.loadCurrencyCache = function() {
        var cache = localStorage.getItem("currencyCache");
        if(!cache) {
            return;
        }

        cache = JSON.parse(cache);
        for(var i = 0; i < root.currencies.length; i++) {
            var currency = root.currencies[i];
            if(currency.id == root.mainCurrencyId) {
                currency.conversion = 1;
                continue;
            }

            var conversion = cache[currency.id];
            currency.conversion = conversion;
        }
    }

    root.getMainCurrencyConversion = function() {
        return new Promise(function(resolve) {
            var mainCurrencyLower = root.mainCurrencyId.toLowerCase();
            fetch("https://cdn.jsdelivr.net/npm/@fawazahmed0/currency-api@latest/v1/currencies/"+ mainCurrencyLower +".json")
            .then(function (response) {
                return response.json();
            })
            .then(function (data) {
                var data = data[mainCurrencyLower];
                var cache = {};
                
                for(var i = 0; i < root.currencies.length; i++) {
                    var currency = root.currencies[i];
                    if(currency.id == root.mainCurrencyId) {
                        currency.conversion = 1;
                        continue;
                    }
                    var conversion = data[currency.id.toLowerCase()];
                    currency.conversion = 1 / conversion;
                    cache[currency.id] = currency.conversion;
                }
                localStorage.setItem("currencyCache", JSON.stringify(cache));
                resolve();
            });
        })
    }

    root.addPages = function () {
        root.pageLoader.addPage({
            name: "home",
            default: true,
            path: "pages/home"
        });

        root.pageLoader.addPage({
            name: "add",
            path: "pages/add"
        });

        root.pageLoader.addPage({
            name: "settings",
            path: "pages/settings"
        });
    }

    root.init = function () {
        root.addDependencies();
        root.setupPageLoader();
        root.addListeners();

        if (navigator.virtualKeyboard) {
            navigator.virtualKeyboard.overlaysContent = true;
        }


        if (root.settingsManager.get("theme")) {
            document.body.setAttribute("data-bs-theme", root.settingsManager.get("theme"));
        }


        if (navigator.serviceWorker) {
            navigator.serviceWorker.register('/serviceWorker.js');
        }

        root.loadCurrencyCache();
        root.loadingScreen.setText("Loading...").show();
        root.getMainCurrencyConversion().then(function() {
            root.pageLoader.load().then(function () {
                root.loadingScreen.hide();
            });
        })
    }

    root.addDependencies = function () {
        root.dependencyInjector.addSingleton("pageLoader", root.pageLoader);
        root.dependencyInjector.addTransient("loadingScreen", LoadingScreen);
        root.dependencyInjector.addSingleton("messageBox", root.messageBox);
        root.dependencyInjector.addSingleton("dependencyInjector", root.dependencyInjector);
        root.dependencyInjector.addSingleton("subscriptionService", root.subscriptionService);
        root.dependencyInjector.addSingleton("currencies", root.currencies);
        root.dependencyInjector.addSingleton("settingsManager", root.settingsManager);
        root.dependencyInjector.addTransient("mainCurrency", function() {
            return root.currencies.find(function(x) {
                return x.id == root.mainCurrencyId;
            });
        });
    }

    root.addListeners = function () {
        document.body.addEventListener('click', function (event) {
            if (event.target.classList.contains("back-button") || event.target.parentElement.classList.contains("back-button")) {
                history.back();
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
                return false;
            }
        }, true)
    }

    root.init();
    return root;
}

var root = new Main();