
var IndexController = function(container, settingsManager, subscriptionService, messageBox, loadingScreen, currencies, mainCurrency) {
    var root = this;
    root.subscriptionId = null;
    root.settingsManager = settingsManager;
    root.messageBox = messageBox;
    root.loadingScreen = loadingScreen;
    root.container = container;
    root.titleBar = root.container.querySelector(".navbar-brand");
    root.subscriptionService = subscriptionService;
    root.currencies = currencies;
    root.mainCurrency = mainCurrency;
    root.form = new FormValidator(root.container.querySelector('.form'));

    root.form.addEventListener('submit', function(data) {
        root.settingsManager.setAll(data);
        localStorage.removeItem("currencyCache");
        location.replace("#home");
        root.loadingScreen.show("Saving and reloading...");
        location.reload();
    });

    root.container.querySelector(".submit").addEventListener('click', function() {
        root.form.submit();
    });

    root.init = function() {
        root.renderCurrencies();
        root.form.setFormData(root.settingsManager.getAll());
    }

    root.renderCurrencies = function() {
        var select = root.container.querySelector("[name='mainCurrencyId']");
        select.innerHTML = "";
        root.currencies.forEach(function(currency) {
            var option = document.createElement("option");
            option.value = currency.id;
            option.innerText = currency.id; 
            select.appendChild(option);
            if(currency.id == root.mainCurrency.id) {
                option.selected = true;
            }
        });
    }

    root.container.addEventListener("pageshown", function() {
        root.init();
    });

    return root;
}