



var IndexController = function(container, settingsManager, subscriptionService, mainCurrency, currencies) {
    var root = this;
    root.subscriptionService = subscriptionService;
    root.container = container;
    root.emptyState = root.container.querySelector(".empty-state");
    root.subscriptionsContainer = root.container.querySelector(".subscriptions");
    root.totalsBar = root.container.querySelector(".totals-bar");
    root.subscriptionTemplate = root.container.querySelector(".subscription-template");
    root.settingsManager = settingsManager;
    root.mainCurrency = mainCurrency;
    root.currencies = currencies;

    root.getExpenses = function(filter) {
        var subscriptions = root.subscriptionService.getAll().filter(filter);
        var total = 0;
        for (var i = 0; i < subscriptions.length; i++) {
            total += root.getConvertedPrice(subscriptions[i].price, root.getCurrency(subscriptions[i].currency));
        }
        return total
    }

    root.getMonthlyExpenses = function() {
        return root.getExpenses(function(subscription) {
            return subscription.type == "monthly";
        });
    }

    root.getYearlyExpenses = function() {
        return root.getExpenses(function(subscription) {
            return subscription.type == "yearly";
        });
    }

    root.getOneTimeExpenses = function() {
        return root.getExpenses(function(subscription) {
            return subscription.type == "one-time" && root.isPending(subscription);
        });
    }

    root.getCurrency = function(currencyId) {
        return root.currencies.find(function(currency) {
            return currency.id == currencyId;
        }) || root.mainCurrency;
    }

    root.isPending = function(subscription) {
        var nextBillingDate = root.getNextBillingDate(subscription);
        return nextBillingDate.diff(moment(), "days") < 0;
    }

    root.getTotals = function() {
        return {
            monthly: root.getMonthlyExpenses(),
            yearly: (root.getMonthlyExpenses() * 12) + root.getOneTimeExpenses() + root.getYearlyExpenses()
        }
    }

    root.getNextBillingDate = function(subscription) {
        var subscriptionDate = moment(subscription.date);
        var nextBillingDate = moment();

        if(subscription.type == "monthly" || subscription.type == "yearly" || subscription.type == "one-time") {
            nextBillingDate.date(subscriptionDate.date());
        }

        if(subscription.type == "yearly" || subscription.type == "one-time") {
            nextBillingDate.month(subscriptionDate.month());
        }

        if(subscription.type == "one-time") {
            nextBillingDate.year(subscriptionDate.year());
        }

        return nextBillingDate;
    }
        

    root.getConvertedPrice = function(value, currency) {
        return value * currency.conversion;
    }

    root.getFormattedPrice = function(value, currencyId) {
        var subscriptionCurrency = root.getCurrency(currencyId);
        return parseFloat(root.getConvertedPrice(value, subscriptionCurrency).toFixed(root.settingsManager.get("decimalPlaces") || 2)).toLocaleString(subscriptionCurrency.format) + " " + mainCurrency.symbol;
    }

    root.getRawFormattedPrice = function(value, currencyId) {
        var subscriptionCurrency = root.getCurrency(currencyId);
        return parseFloat(parseFloat(value).toFixed(root.settingsManager.get("decimalPlaces") || 2)).toLocaleString(subscriptionCurrency.format) + " " + subscriptionCurrency.symbol;
    }

    root.render = function() {
        var subscriptions = root.subscriptionService.getAll();
        if(subscriptions.length === 0) {
            root.emptyState.hidden = false;
            root.subscriptionsContainer.hidden = true;
            root.totalsBar.hidden = true;
            return;
        }

        root.emptyState.hidden = true;
        root.subscriptionsContainer.hidden = false;
        root.totalsBar.hidden = false;
        root.subscriptionsContainer.innerHTML = "";
        for (var i = 0; i < subscriptions.length; i++) {
            var subscription = subscriptions[i];
            var subscriptionElement = root.subscriptionTemplate.content.cloneNode(true).firstElementChild;
            subscriptionElement.querySelector(".name").innerText = subscription.name;
            subscriptionElement.querySelector(".profile-picture").innerText = subscription.name.split(" ").map(function(word) {
                return word.charAt(0).toUpperCase();
            }).join("");
            subscriptionElement.querySelector(".profile-picture").style.backgroundColor = subscription.color;
            subscriptionElement.querySelector(".description").innerText = subscription.description;
            subscriptionElement.querySelector(".price").innerText = root.settingsManager.get("localizePrices") ? 
            root.getFormattedPrice(subscription.price, subscription.currency) : root.getRawFormattedPrice(subscription.price, subscription.currency);


            var nextBillingDate = root.getNextBillingDate(subscription);
            subscriptionElement.querySelector(".state").innerText = root.isPending(subscription) ? "Cycle Paid" :  nextBillingDate.fromNow();
            root.subscriptionsContainer.appendChild(subscriptionElement);

            (function(subscriptionElement, subscription) {
                subscriptionElement.addEventListener("click", function() {
                    location.href = "#add?id=" + subscription.id;
                });
            })(subscriptionElement, subscription);
        }


        var totals = root.getTotals();
        root.container.querySelector(".monthly-expenses").innerText = root.getFormattedPrice(totals.monthly, mainCurrency.id);
        root.container.querySelector(".yearly-expenses").innerText = root.getFormattedPrice(totals.yearly, mainCurrency.id);
    }


    root.container.addEventListener("pageshown", function() {
        root.render();
    })
    
    return root;
}