
var IndexController = function(container, subscriptionService, messageBox, currencies, mainCurrency) {
    var root = this;
    root.subscriptionId = null;
    root.messageBox = messageBox;
    root.container = container;
    root.titleBar = root.container.querySelector(".navbar-brand");
    root.subscriptionService = subscriptionService;
    root.currencies = currencies;
    root.mainCurrency = mainCurrency;
    root.form = new FormValidator(root.container.querySelector('.form'));

    root.getQueryParams = function () {
        var url = location.href;
        var obj = {};
        var query = url.split("?")[1];
        if (!query) {
            return obj;
        }

        var params = query.split("&");
        if (params.length == 0) {
            return obj;
        }

        for (var i = 0; i < params.length; i++) {
            var pair = params[i].split("=");
            obj[decodeURI(pair[0])] = decodeURI(pair[1]);
        }

        return obj;
    };
    
    root.form 
        .addValidation("name", "required")
        .addValidation("date", "required")
        .addValidation("price", "required")
        .addValidation("price", "positive");

    root.form.addEventListener('submit', function(data) {
        if(root.subscriptionId) {
            data.id = root.subscriptionId;
        }

        root.subscriptionService.add(data);

        root.messageBox.show("Done").hide(1000);
        location.replace("#home");
    });


    root.container.querySelector(".submit").addEventListener('click', function() {
        root.form.submit();
    });

    root.container.querySelector(".delete").addEventListener('click', function() {
        var confirmation = confirm("Are you sure you want to delete this subscription?");
        if(confirmation) {
            root.subscriptionService.removeById(root.subscriptionId);
            root.messageBox.show("Deleted").hide(1000);
            location.replace("#home");
        }
    });

    root.init = function() {
        root.renderCurrencies();
        var queryParams = root.getQueryParams();
        var subscription = root.subscriptionService.getById(queryParams.id);
        if(subscription) {
            root.form.setFormData(subscription);
            root.titleBar.innerText = "Edit Subscription";
            root.container.querySelector(".delete").hidden = false;
            root.subscriptionId = subscription.id;
        } else {
            root.subscriptionId = null;
            root.form.setFormData({
                name: "",
                date: "",
                price: "",
                description: ""
            });
            root.titleBar.innerText = "Add Subscription";
            root.container.querySelector(".delete").hidden = true;
        }
    }

    root.container.addEventListener("pageshown", function() {
        root.init();
    });

    root.container.addEventListener("hashchange", function() {
        root.init();
    });

    root.renderCurrencies = function() {
        var select = root.container.querySelector("[name='currency']");
        select.innerHTML = "";
        root.currencies.forEach(function(currency) {
            var option = document.createElement("option");
            option.value = currency.id;
            option.innerText = currency.id; 
            select.appendChild(option);
            if(currency.id == root.mainCurrency.id) {
                option.selected = true;
            }
        });
    }

    return root;
}